// DOM - Document Object Model
let inputBr1 = document.getElementById("broj1");
let inputBr2 = document.getElementById("broj2");
let btnIzracunaj = document.getElementById("izracunaj");
let btnResetuj = document.getElementById("resetuj");
let ispisRezultata= document.getElementById("rezultat");

btnIzracunaj.addEventListener("click", (event) => {
    event.preventDefault(); // Submit dugme je podrazumevano radilo osvežavanje stranice, preventDefault stopira podrazumevana ponašanja stranice
    // Ako ne želite da dugme radi reload stranice, koristite <input type="button" value="Izračunaj" id="izracunaj">

    let valueBr1 = Number(inputBr1.value); // Čitam vrednost koja je uneta u prvo input polje, ali pošto se očitava kao string, konvertujemo je u tip Number
    let valueBr2 = Number(inputBr2.value); // Čitam vrednost koja je uneta u drugo input polje, ali pošto se očitava kao string, konvertujemo je u tip Number
    let operacija = document.querySelector("input[name='operacija']:checked"); // Vraća ceo HTML element radio button na koji je kliknuto
    let valueOperacija = operacija.value; // Vraća vrednost radio button-a na koji je kliknuto
    
    // Možemo krenuti sa računanjem, pošto smo preuzeli sve unete vrednosti
    let rez = 0; // Beležimo rezultat
    let operacijaIspis = ""; // Beležimo operaciju za kasniji ispis na ekranu

    if(valueOperacija == "plus") {
        rez = valueBr1 + valueBr2;
        operacijaIspis = "+";
    } else if(valueOperacija == "minus") {
        rez = valueBr1 - valueBr2;
        operacijaIspis = "-";
    } else if(valueOperacija == "puta") {
        rez = valueBr1 * valueBr2;
        operacijaIspis = "*";
    } else {
        operacijaIspis = "/";
        if(valueBr2 == 0) {
            rez = "Zabranjeno je deliti nulom";
        } else {
            rez = valueBr1 / valueBr2;
            rez = rez.toFixed(2); // Zaokruži broj na dve decimale
        }
    }

    // Prilikom ispisa, ako je drugi uneti broj manji od nule, stavljamo ga u zagrade, da ne bi pisalo npr. 5- -2 = 7, nego 5-(-2)=7
    if(valueBr2 < 0) {
        ispisRezultata.innerHTML = `${valueBr1} ${operacijaIspis} (${valueBr2}) = ${rez}`;
    } else {
        ispisRezultata.innerHTML = `${valueBr1} ${operacijaIspis} ${valueBr2} = ${rez}`;
    }
});

// Resetovanje paragrafa u kome se vrši ispis
btnResetuj.addEventListener("click", () => {
    ispisRezultata.innerHTML = "";
});